#ifndef __C4DBASECHANNEL_H
#define __C4DBASECHANNEL_H

#include "ge_math.h"
#include "ge_vector.h"
#include "c4d_basebitmap.h"
#include "c4d_gui.h"
#include "c4d_baselist.h"

class Filename;
class BaseBitmap;
class BaseContainer;
class TextureGroup;
class GeDialog;
class PluginShader;
struct VolumeData;

class PluginShader : public BaseList2D {};

class BaseChannel : public Atom
{
	private:
		BaseChannel(void);
	public:
		Bool Compare(BaseChannel *dst);
		
		LONG InitTexture(InitRenderStruct *is); 
		void FreeTexture(void);
	
		BaseContainer		GetData(void);
		void						SetData(const BaseContainer &ct);

		LONG						GetShaderID(void);
		PluginShader*		GetShader(void);
		BaseBitmap*			GetBitmap(void) { return C4DOS.Ba->GetBitmap(this); }

		Vector Sample(VolumeData *vd, Vector *p, Vector *delta, Vector *n, Real t, LONG tflag, Real off, Real scale) { return C4DOS.Ba->SampleEx((BaseChannel*)this,vd,p,delta,n,t,tflag,off,scale); }

		Bool Attach(GeListNode *element);

		static BaseChannel *Alloc(void);
		static void Free(BaseChannel *&bc);
};

class TexturePreview : public GeUserArea
{
	private:
		TextureGroup *texgroup;
	
	public:
		TexturePreview(void);
		Bool InitPreview(TextureGroup *t_texgroup);

		// for overloading (for special message handling)
		virtual LONG Message(const BaseContainer &msg,BaseContainer &result);
		virtual Bool GetMinSize(LONG &w,LONG &h);
		virtual void Draw      (LONG x1,LONG y1,LONG x2,LONG y2);
};

class TextureGroup
{
	private:
		_TextureGroup *tg;
		BaseChannel		*bc;
		CDialog				*cd;
		TexturePreview texprev;

	public:
		TextureGroup(void);
		~TextureGroup(void);

		Bool Init(BaseChannel *bc, GeDialog *cd, LONG idimage, LONG idname, LONG idbluroff, LONG idblurstr, LONG idint, LONG idinfo, LONG idpreview, LONG idedit, LONG idpopup);
		void Update(void);
		Bool Message(const BaseContainer &msg,Bool preview);
};

#endif
